import numpy as np
import pandas as pd

# Funkcja przeliczająca wychylenie na C_L
def calculate_CL(deflection_deg):
    """
    Funkcja oblicza współczynnik nośności CL na podstawie kąta wychylenia lotki w stopniach.
    Zakładamy, że dla wychylenia w górę CL będzie większe niż dla wychylenia w dół.
    """
    deflection_rad = np.radians(deflection_deg)  # Zamiana stopni na radiany
    if deflection_deg > 0:
        # Wychylenie w górę (większy CL)
        CL = aail * deflection_rad
    else:
        # Wychylenie w dół (mniejszy CL)
        CL = 0.7*aail * deflection_rad
    return CL

# Dane stałe
rho = 1.225  # kg/m^3
S_lotki = 0.048  # m^2 (powierzchnia jednej lotki)
r = 0.55  # m (ramię działania siły - od środka masy do środka lotki)
Ix = 0.72  # Moment bezwładności wokół osi X (kg·m^2)
t = 1  # czas działania (s)
aail=0.1
# Wprowadź wychylenie lotek w stopniach (np. prawa w górę, lewa w dół)
deflection_right = 15  # Wychylenie prawej lotki w górę (w stopniach)
deflection_left = -15 * 0.75  # Wychylenie lewej lotki w dół (w stopniach)

# Obliczenie C_L dla obu lotek
Cl_right = calculate_CL(deflection_right)
Cl_left = calculate_CL(deflection_left)

# Zakres prędkości lotu
V_range = np.arange(10, 45, 5)

# Obliczenia
results = []

for V in V_range:
    # Siła aerodynamiczna dla lotek (prawej i lewej)
    F_l_right = 0.5 * rho * V**2 * S_lotki * Cl_right
    F_l_left = 0.5 * rho * V**2 * S_lotki * Cl_left
    # Moment od dwóch lotek (dla obu lotek)
    Mx_right = F_l_right * r
    Mx_left = F_l_left * r
    # Suma momentów (prawej i lewej lotki)
    Mx_total = np.abs(Mx_right) + np.abs(Mx_left)
    # Przyspieszenie kątowe
    alpha_x = Mx_total / Ix
    # Prędkość obrotowa po 1s (rad/s)
    omega_x_rad = alpha_x * t
    # Prędkość obrotowa (°/s)
    omega_x_deg = np.degrees(omega_x_rad)
    # Zapisujemy wyniki
    results.append([V, round(F_l_right, 3), round(F_l_left, 3), round(Mx_total, 3), round(alpha_x, 3), round(omega_x_rad, 3), round(omega_x_deg, 1)])

# Tabela wyników
columns = ["V (m/s)", "Fₗ (right) (N)", "Fₗ (left) (N)", "Mₓ (Nm)", "αₓ (rad/s²)", "ωₓ (rad/s)", "ωₓ (°/s)"]
df = pd.DataFrame(results, columns=columns)

# Wyświetlanie tabelki
print(df)

